using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
// Import MySql Data, MySqlClient and System.IO namespaces
using MySql.Data;
using MySql.Data.MySqlClient;
using System.IO;
// Import namespaces for iTextSharp
using iTextSharp.text;
using iTextSharp.text.pdf;

public partial class _SelectMysql : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // This code will only be executed if the page load not is a post back.
        if (!Page.IsPostBack)
        {
            // Get values from session variables and store these values in hidden fields.
            HiddenCompanyID.Value = Convert.ToString(Session["CompanyID"]);
            HiddenYearID.Value = Convert.ToString(Session["YearID"]);
            HiddenCompanyName.Value = Convert.ToString(Session["CompanyName"]);
        }
    }

    protected void BtnSelectAssets_Click(object sender, EventArgs e)
    {
        // This is code to select data to a dataset with two tables so that we kan make groups and calculate values
        // Asset accounts in parentrepeater and assets inside childrepeater.

        // Declare variables for a connection string and two SELECT statements.
        string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
        string sql = "SELECT AssetTypeID, AssetAccount, TypeName FROM AssetType WHERE CompanyID = @CompanyID "
        + "GROUP BY AssetTypeID, AssetAccount, TypeName ORDER BY AssetAccount ASC";
        string sql2 = "SELECT A.AssetOwnID, A.AssetType, A.AssetName, A.PurchaseDate, A.PurchasePrice, "
        + "SUM(COALESCE(SumIB, 0)) As YearIB, SUM(COALESCE(SumYearDep,0)) As YearDep, SUM(COALESCE(SumIB, 0) "
        + "+ COALESCE(SumYearDep,0)) As SumAckDeprication, SUM(A.PurchasePrice - (COALESCE(SumIB, 0) + "
        + "COALESCE(SumYearDep,0))) As AccountedValue FROM Assets AS A LEFT OUTER JOIN (SELECT AssetID, "
        + "SUM(IBValue) As SumIB FROM IBDeprication WHERE YearID = @YearID GROUP BY AssetID) As IB ON A.AssetID "
        + "= IB.AssetID LEFT OUTER JOIN (SELECT AssetID, SUM(DepricationValue) As SumYearDep FROM Deprication "
        + "WHERE YearID = @YearID GROUP BY AssetID) AS D ON A.AssetID = D.AssetID WHERE A.CompanyID = @CompanyID "
        + "AND A.SoldScraped = '0' OR A.DateSold > @Slutdatum GROUP BY A.AssetOwnID, A.AssetType, A.AssetName, "
        + "A.PurchaseDate, A.PurchasePrice ORDER BY A.PurchaseDate ASC";

        // Create a MySqlConnection. The using block is used to call dispose (close) automatically even if there 
        // are an exception.
        using (MySqlConnection cn = new MySqlConnection(ConnString))
        {
            // Create the first MySqlDataAdapter.
            MySqlDataAdapter ad = new MySqlDataAdapter();

            // Create the first MySqlCommand.
            MySqlCommand cmd = new MySqlCommand(sql, cn);

            // Create the second MySqlDataAdapter.
            MySqlDataAdapter ad2 = new MySqlDataAdapter();

            // Create the second MySqlCommand.
            MySqlCommand cmd2 = new MySqlCommand(sql2, cn);

            // Create a new dataset, a dataset can contain several datatables that are related to each other.
            DataSet ds = new DataSet();

            // Add parameters.
            cmd.Parameters.AddWithValue("@CompanyID", HiddenCompanyID.Value);
            cmd2.Parameters.AddWithValue("@YearID", HiddenYearID.Value);
            cmd2.Parameters.AddWithValue("@CompanyID", HiddenCompanyID.Value);
            cmd2.Parameters.AddWithValue("@Slutdatum", txtEndDate.Text);

            // The Try/Catch/Finally block is used to handle exceptions in the application.
            try
            {
                // Open the MySqlConnection.
                cn.Open();

                // Fill dataset with assettypes as the first table.
                ad.SelectCommand = cmd;
                ad.Fill(ds, "AssetTypes");

                // Fill dataset with assets as the second table.
                ad2.SelectCommand = cmd2;
                ad2.Fill(ds, "Assets");

                // Create the relation bewtween the AssetTypes and Assets tables.
                ds.Relations.Add("assetsrelation", ds.Tables["AssetTypes"].Columns["AssetTypeID"], ds.Tables["Assets"].Columns["AssetType"]);

                // Calculate subtotals
                DataColumn PPTotal = new DataColumn("PPTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).PurchasePrice)");
                PPTotal.AutoIncrement = false;
                PPTotal.ReadOnly = true;
                DataColumn IBTotal = new DataColumn("IBtotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).YearIB)");
                IBTotal.AutoIncrement = false;
                IBTotal.ReadOnly = true;
                DataColumn YearTotal = new DataColumn("YearDepTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).YearDep)");
                YearTotal.AutoIncrement = false;
                YearTotal.ReadOnly = true;
                DataColumn AckDepTotal = new DataColumn("AckDepTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).SumAckDeprication)");
                AckDepTotal.AutoIncrement = false;
                AckDepTotal.ReadOnly = true;
                DataColumn AccValueTotal = new DataColumn("AccValueTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).AccountedValue)");
                AccValueTotal.AutoIncrement = false;
                AccValueTotal.ReadOnly = true;

                // Add columns to the AssetTypes table.
                ds.Tables["AssetTypes"].Columns.Add(PPTotal);
                ds.Tables["AssetTypes"].Columns.Add(IBTotal);
                ds.Tables["AssetTypes"].Columns.Add(YearTotal);
                ds.Tables["AssetTypes"].Columns.Add(AckDepTotal);
                ds.Tables["AssetTypes"].Columns.Add(AccValueTotal);

                // Bind the AssetTypes table to the parentrepeater control, and call DataBind. Data for the 
                // childrepeater will be retrieved in Select-mysql.aspx from the dataset.
                parentRepeater.DataSource = ds.Tables["AssetTypes"];
                Page.DataBind();
            }
            catch (Exception ex)
            {
                // Catch a general exception.
                Response.Write(ex.Message);
            }
            finally
            {
                // Dispose of MySqlDataAdapters, MySqlCommands and the DataSet.
                ad.Dispose();
                ad2.Dispose();
                cmd.Dispose();
                cmd2.Dispose();
                ds.Dispose();
            }
        }
    }
    protected void btnPrintKvarAnlagg_Click(object sender, EventArgs e)
    {
        
        // This code creates a pdf (itextsharp) that the user can download after the user has clicked the "Print report" button. The data
        // for the pdf report are each row in the repeater control. You need to have the file "itextsharp.dll" in the "bin"
        // folder to be able to create pdf reports according to this example.

        //Create pdf document
        Document PdfDocument = new Document(PageSize.A4);
        PdfWriter.GetInstance(PdfDocument, Response.OutputStream);

        //IF YOU WANT TO SAVE THE PDF TO THE WEBSERVER YOU CAN USE THIS EXAMPLE CODE INSTEAD OF THE ROW ABOVE
        //string AssetUser = Page.User.Identity.Name;
        //string SavePdf = "pdf/" + AssetUser.Replace(".", "") + ".pdf";
        //PdfWriter.GetInstance(PdfDocument, new FileStream(Server.MapPath(SavePdf), FileMode.Create));

        // Set margins for the document.
        PdfDocument.SetMargins(43, 43, 43, 43);

        // Fonts that can be used in this document
        BaseFont calibri = BaseFont.CreateFont(Server.MapPath("fonts/Calibri.TTF"), BaseFont.WINANSI, BaseFont.EMBEDDED);
        Font BoldHeading = new Font(calibri, 20, Font.BOLD);
        Font BoldText = new Font(calibri, 12, Font.BOLD);
        Font Text = new Font(calibri, 12);
        Font MiddleBoldText = new Font(calibri, 8, Font.BOLD);
        Font MiddleItalicText = new Font(calibri, 8, Font.ITALIC);
        Font MiddleText = new Font(calibri, 8);

        // We add a footer
        HeaderFooter FooterOne = new HeaderFooter(new Phrase("", BoldText), true);
        FooterOne.Alignment = Element.ALIGN_RIGHT;
        PdfDocument.Footer = FooterOne;

        // Open the document.
        PdfDocument.Open();

        Paragraph CompanyP1 = new Paragraph(HiddenCompanyName.Value, BoldText);
        Paragraph Heading = new Paragraph("Assets", BoldHeading);
        Paragraph EndDate = new Paragraph("End date: " + txtEndDate.Text, Text);
        Paragraph PrintDate = new Paragraph("Date printed: " + DateTime.Now.ToString("yyyy-MM-dd"), Text);
        CompanyP1.Alignment = Element.ALIGN_LEFT;
        Heading.Alignment = Element.ALIGN_CENTER;
        EndDate.Alignment = Element.ALIGN_LEFT;
        PrintDate.Alignment = Element.ALIGN_LEFT;
        PdfDocument.Add(CompanyP1);
        PdfDocument.Add(Heading);
        PdfDocument.Add(new Paragraph(" ", Text));
        PdfDocument.Add(EndDate);
        PdfDocument.Add(PrintDate);

        PdfDocument.Add(new Paragraph(" ", Text));

        // Create the first and only table
        PdfPTable AnlaggningarTable = new PdfPTable(8);
        AnlaggningarTable.HorizontalAlignment = Element.ALIGN_LEFT;
        float[] sWidths = {10,20,10,12,12,12,12,12};
        AnlaggningarTable.SetTotalWidth(sWidths);
        AnlaggningarTable.WidthPercentage = 100;
        AnlaggningarTable.DefaultCell.Border = 0;

        AnlaggningarTable.DefaultCell.BorderWidthTop = 1;
        AnlaggningarTable.DefaultCell.BorderWidthBottom = 1;
        AnlaggningarTable.AddCell(new Phrase("Asset ID", MiddleBoldText));
        AnlaggningarTable.AddCell(new Phrase("Name", MiddleBoldText));
        AnlaggningarTable.AddCell(new Phrase("Purch. date", MiddleBoldText));
        AnlaggningarTable.DefaultCell.HorizontalAlignment = Element.ALIGN_RIGHT;
        AnlaggningarTable.AddCell(new Phrase("Cost", MiddleBoldText));
        AnlaggningarTable.AddCell(new Phrase("OB acc. depr.", MiddleBoldText));
        AnlaggningarTable.AddCell(new Phrase("Year deprication", MiddleBoldText));
        AnlaggningarTable.AddCell(new Phrase("Acc. depr.", MiddleBoldText));
        AnlaggningarTable.AddCell(new Phrase("Book value", MiddleBoldText));

        AnlaggningarTable.DefaultCell.Border = 0;

        // Fill the report with parent rows from the repeater control
        foreach (RepeaterItem RepeaterRow in parentRepeater.Items)
        {
            Literal AssetAccountLiteralObj = (Literal)RepeaterRow.FindControl("AssetAccountLiteral");
            Literal AssetTypeNameLiteralObj = (Literal)RepeaterRow.FindControl("AssetTypeNameLiteral");
            Label PPpriceLabelObj = (Label)RepeaterRow.FindControl("PPpriceLabel");
            Label IBTotalLabelObj = (Label)RepeaterRow.FindControl("IBTotalLabel");
            Label YearDepLabelObj = (Label)RepeaterRow.FindControl("YearDepLabel");
            Label AckDepLabelObj = (Label)RepeaterRow.FindControl("AckDepLabel");
            Label AccTotalLabelObj = (Label)RepeaterRow.FindControl("AccTotalLabel");

            if (!(PPpriceLabelObj.Text == null))
            {
                AnlaggningarTable.DefaultCell.HorizontalAlignment = Element.ALIGN_LEFT;
                AnlaggningarTable.AddCell(new Phrase(AssetAccountLiteralObj.Text, MiddleBoldText));
                AnlaggningarTable.AddCell(new Phrase(AssetTypeNameLiteralObj.Text, MiddleBoldText));
                AnlaggningarTable.AddCell("");
                AnlaggningarTable.AddCell("");
                AnlaggningarTable.AddCell("");
                AnlaggningarTable.AddCell("");
                AnlaggningarTable.AddCell("");
                AnlaggningarTable.AddCell("");

                Repeater ChildRow = (Repeater)RepeaterRow.FindControl("childRepeater");

                // Fill the report with child rows from the repeater control
                foreach (RepeaterItem ItemRow in ChildRow.Items)
                {
                    Literal AssetOwnIDLiteralObj = (Literal)ItemRow.FindControl("AssetOwnIDLiteral");
                    Literal AssetNameLiteralObj = (Literal)ItemRow.FindControl("AssetNameLiteral");
                    Literal PurchaseDateLiteralObj = (Literal)ItemRow.FindControl("PurchaseDateLiteral");
                    Literal PurchasePriceLiteralObj = (Literal)ItemRow.FindControl("PurchasePriceLiteral");
                    Literal YearIBLiteralObj = (Literal)ItemRow.FindControl("YearIBLiteral");
                    Literal YearDepLiteralObj = (Literal)ItemRow.FindControl("YearDepLiteral");
                    Literal SumAckDepricationLiteralObj = (Literal)ItemRow.FindControl("SumAckDepricationLiteral");
                    Literal AccountedValueLiteralObj = (Literal)ItemRow.FindControl("AccountedValueLiteral");

                    AnlaggningarTable.DefaultCell.HorizontalAlignment = Element.ALIGN_LEFT;
                    AnlaggningarTable.AddCell(new Phrase(AssetOwnIDLiteralObj.Text, MiddleText));
                    AnlaggningarTable.AddCell(new Phrase(AssetNameLiteralObj.Text, MiddleText));
                    AnlaggningarTable.AddCell(new Phrase(PurchaseDateLiteralObj.Text, MiddleText));
                    AnlaggningarTable.DefaultCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                    AnlaggningarTable.AddCell(new Phrase(PurchasePriceLiteralObj.Text, MiddleText));
                    AnlaggningarTable.AddCell(new Phrase(YearIBLiteralObj.Text, MiddleText));
                    AnlaggningarTable.AddCell(new Phrase(YearDepLiteralObj.Text, MiddleText));
                    AnlaggningarTable.AddCell(new Phrase(SumAckDepricationLiteralObj.Text, MiddleText));
                    AnlaggningarTable.AddCell(new Phrase(AccountedValueLiteralObj.Text, MiddleText));
                }

                // Fill the pdf report with sum rows
                AnlaggningarTable.DefaultCell.HorizontalAlignment = Element.ALIGN_LEFT;
                AnlaggningarTable.AddCell(new Phrase("Sum", MiddleBoldText));
                AnlaggningarTable.AddCell("");
                AnlaggningarTable.AddCell("");
                AnlaggningarTable.DefaultCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                AnlaggningarTable.AddCell(new Phrase(PPpriceLabelObj.Text, MiddleBoldText));
                AnlaggningarTable.AddCell(new Phrase(IBTotalLabelObj.Text, MiddleBoldText));
                AnlaggningarTable.AddCell(new Phrase(YearDepLabelObj.Text, MiddleBoldText));
                AnlaggningarTable.AddCell(new Phrase(AckDepLabelObj.Text, MiddleBoldText));
                AnlaggningarTable.AddCell(new Phrase(AccTotalLabelObj.Text, MiddleBoldText));
            }
        }

        // Add the table to the pdf document
        PdfDocument.Add(AnlaggningarTable);

        // End everything
        PdfDocument.Close();

        // Open the generated pdf
        Response.ContentType = "Application/pdf";
        Response.AppendHeader("Content-Disposition", "attachment; filename=Assets.pdf");
        Response.Flush();
        Response.Close();

        // IF YOU WANT A USER TO OPEN A PDF THAT IS SAVED ON THE WEBSERVER YOU CAN USE THIS CODE INSTEAD
        //Response.Clear();
        //Response.ContentType = "Application/pdf";
        //Response.AppendHeader("Content-Disposition", "attachment; filename=Assets.pdf");
        //Response.WriteFile(SavePdf);
        //Response.Flush();
        //Response.Close();

        // IF YOU WANT TO DELETE A FILE ON THE WEBSERVER YOU CAN USE THIS CODE
        //FileInfo FileToDelete = new FileInfo(Server.MapPath("PathToFileAndFileName"));
        //if (FileToDelete.Exists)
        //{
        //    FileToDelete.Delete();
        //}
    }
}
